<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Provides the {@link \core_analytics\stats} class.
 *
 * @package     core_analytics
 * @copyright   2019 David Mudrák <david@moodle.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace core_analytics;

defined('MOODLE_INTERNAL') || die();

/**
 * Provides stats and meta information about the analytics usage on this site.
 *
 * @copyright 2019 David Mudrák <david@moodle.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class stats {

    /**
     * Return the number of models enabled on this site.
     *
     * @return int
     */
    public static function enabled_models(): int {
        return count(manager::get_all_models(true));
    }

    /**
     * Return the number of predictions generated by the system.
     *
     * @return int
     */
    public static function predictions(): int {
        global $DB;

        return $DB->count_records('analytics_predictions');
    }

    /**
     * Return the number of suggested actions executed by users.
     *
     * @return int
     */
    public static function actions(): int {
        global $DB;

        return $DB->count_records('analytics_prediction_actions');
    }

    /**
     * Return the number of suggested actions flagged as not useful.
     *
     * @return int
     */
    public static function actions_not_useful(): int {
        global $DB;

        // Simple version using core's TYPE_NEGATIVE actions.
        return $DB->count_records_select('analytics_prediction_actions',
            'actionname = :notuseful OR actionname = :incorrectlyflagged',
            ['notuseful' => prediction::ACTION_NOT_USEFUL, 'incorrectlyflagged' => prediction::ACTION_INCORRECTLY_FLAGGED]);
    }
}
